/**
 * 
 */
package com.ejie.ab18a.envioBoletin;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.SOAPException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

import com.ejie.ab18a.consulta.Ab18aRealizarProcesoBD;
import com.ejie.ab18a.log.Ab18aLog;
import com.ejie.ab18a.modelo.Ab18aConfiguracionAplicacion;
import com.ejie.ab18a.modelo.Ab18aPeticionEnvio;
import com.ejie.ab18a.modelo.Ab18aPlantillasXSLT;
import com.ejie.ab18a.properties.Ab18aPropertiesBatchManager;
import com.ejie.ab18a.utilidades.Ab18aConexionOracle;
import com.ejie.ab18a.utilidades.Ab18aConstantes;
import com.ejie.ab18a.utilidades.Ab18aException;
import com.ejie.ab18a.utilidades.Ab18aUtils;
import com.ejie.ab18a.utilidades.Ab18aWSUtils;

import eu.europa.ec.publications.esentool.rest.client.EsentoolRestClient;
import eu.europa.ec.publications.esentool.rest.client.EsentoolRestClient.EsentoolRestClientBuilder;
import eu.europa.ec.publications.esentool.rest.client.NoticeInformation;
import eu.europa.ec.publications.esentool.rest.client.RestClientException;

/**
 * @author XXXX
 * 
 */
public class Ab18aEnvioBoletines {

	private Ab18aEnvioBoletines() {

	}

	/**
	 * @param args
	 */
	public static void main(String[] args) throws Ab18aException {
		Connection connectionOracle = null;
		Ab18aLog.configure("Ab18aEnvioBoletin", 1);

		final Integer RECHAZADA_VALIDACION_ENVIO = 4;

		final Integer ESTADO_ERROR_SERVICIO_ENVIO = 6;

		final Integer ESTADO_PENDIENTE_PUBLICAR = 7;

		Map<Integer, Ab18aConfiguracionAplicacion> mapConfiguracionAplicacion = new HashMap<Integer, Ab18aConfiguracionAplicacion>();

		String nombre_metodo = "envioBoletines";
		Ab18aLog.debug(Ab18aEnvioBoletines.class.getName(), nombre_metodo, "Comienza ", 1);

		try {

			if (connectionOracle == null) {
				connectionOracle = Ab18aConexionOracle.conectar(args);
			}

			Ab18aLog.debug(Ab18aEnvioBoletines.class.getName(), nombre_metodo, "Conexión abierta", 1);

			Integer idEstado = 0;

			mapConfiguracionAplicacion.putAll(Ab18aRealizarProcesoBD.getInstance().obtenerFlagsConfiguracion(connectionOracle));

			List<Ab18aPeticionEnvio> lstPeticiones = Ab18aRealizarProcesoBD.getInstance().obtenerPeticionesEnvio(connectionOracle);

			// Comprobamos si hay alguna peticion en la lista
			if (lstPeticiones != null && !lstPeticiones.isEmpty()) {

				Ab18aLog.debug(Ab18aEnvioBoletines.class.getName(), nombre_metodo, "Se van a procesar " + lstPeticiones.size() + " peticiones.", 1);

				// Instanciamos el cliente de eSentool
				EsentoolRestClient client = new EsentoolRestClientBuilder(Ab18aConstantes.URL_ERPI_SUBMIT_NOTICE, Ab18aConstantes.ESENTOOL_USER,
						Ab18aConstantes.ESENTOOL_PW).build();
				// EsentoolRestClient client = new
				// EsentoolRestClientBuilder("https://esentool.ted.europa.eu/api/qualification","TED39","KONTRATAZIOa1!").build();

				// Recorremos la lista
				for (Ab18aPeticionEnvio peticion : lstPeticiones) {

					try {
						String[] versionSubversion = Ab18aEnvioBoletines.obtenerVersionAnuncioDOUE(peticion);

						// Se obtienen todas las plantillas de BD
						List<Ab18aPlantillasXSLT> lstPlantillas = Ab18aRealizarProcesoBD.getInstance().obtenerPlantillasXSLT(connectionOracle,
								versionSubversion);

						Ab18aLog.debug(Ab18aEnvioBoletines.class.getName(), nombre_metodo, "Procesando peticion " + peticion.getT01IdPeticionEnvio(),
								1);
						// Validaciones logicas (XSLT)
						boolean validacionOk = true;
						if (mapConfiguracionAplicacion != null && !mapConfiguracionAplicacion.isEmpty()
								&& mapConfiguracionAplicacion.containsKey(Ab18aConstantes.VALIDACION_LOGICAS)
								&& mapConfiguracionAplicacion.get(Ab18aConstantes.VALIDACION_LOGICAS) != null
								&& mapConfiguracionAplicacion.get(Ab18aConstantes.VALIDACION_LOGICAS).getT00Valor()) {
							validacionOk = Ab18aEnvioBoletines.realizarValidacionesLogicas(connectionOracle, lstPlantillas, peticion);
						}

						if (validacionOk) {
							// Enviamos el anuncio xml en base 64
							if (client != null) {
								byte[] xml = peticion.getT01AnuncioXml().getBytes();
								Ab18aLog.debug(Ab18aEnvioBoletines.class.getName(), nombre_metodo, "Procesando XML " + peticion.getT01AnuncioXml(), 1);
								Ab18aLog.debug(Ab18aEnvioBoletines.class.getName(), nombre_metodo,
										"Procesando Base64 byte[] " + Base64.encodeBase64(xml), 1);
								NoticeInformation information = null;
								try {
									information = client.submitNotice(Base64.encodeBase64(xml));
									//information = client.submitNotice(xml);
								} catch (RestClientException rce) {
									Map<String, Object> mapaAtributos = new HashMap<String, Object>();
									// Comprobamos que error es
									if (rce.getError() != null) {
										mapaAtributos.put("descError", rce.getError().getMessage());
										Integer status = rce.getError().getStatus();
										Integer numIntentos = peticion.getT01NumIntentos();
										// Si es un 400 ponemos el número de
										// reintentos
										// directamente en 5
										if (status.compareTo(Ab18aConstantes.STATUS_400) == 0) {
											numIntentos = 5;
										} else {
											// De lo contrario, sumamos uno
											if (numIntentos == null) {
												numIntentos = 0;
											} else {
												numIntentos++;
											}
										}
										mapaAtributos.put("numIntentos", numIntentos);
										mapaAtributos.put("idPeticion", peticion.getT01IdPeticionEnvio());
										mapaAtributos.put("idEstado", ESTADO_ERROR_SERVICIO_ENVIO);
									}
									Ab18aRealizarProcesoBD.getInstance().actualizarPeticionEnvio(connectionOracle, mapaAtributos);
									Ab18aLog.error(Ab18aEnvioBoletines.class.getName(), nombre_metodo, "Error al submitear el notice, Status: "
											+ rce.getError().getStatus() + " causa: " + rce.getError().getMessage(), 1);
								} catch (Exception e) {
									Ab18aLog.error(Ab18aEnvioBoletines.class.getName(), nombre_metodo,
											"Error al submitear el notice, causa: " + e.getMessage(), 1);
								}

								// Si el objeto NoticeInformation no es nulo,
								// significa que el submit ha ido bien
								if (information != null) {
									Ab18aLog.debug(Ab18aEnvioBoletines.class.getName(), nombre_metodo,
											"Status peticion " + information.getReasonCode(), 1);
									// Fase de almacenamiento
									// Actualizamos los datos de la petición en
									// PETICION_ENVIO
									Ab18aRealizarProcesoBD.getInstance().almacenarEnvioBoletin(connectionOracle, information,
											peticion.getT01IdPeticionEnvio().intValue());
									Ab18aRealizarProcesoBD.getInstance().almacenarValidaciones(connectionOracle, information,
											peticion.getT01IdPeticionEnvio().intValue());

									if (information.getStatus().name().equals("RECEIVED")) {
										Map<String, Object> mapaAtributos = new HashMap<String, Object>();
										mapaAtributos.put("idPeticion", peticion.getT01IdPeticionEnvio());
										mapaAtributos.put("idEstado", ESTADO_PENDIENTE_PUBLICAR);
										mapaAtributos.put("numIntentos", peticion.getT01NumIntentos());
										mapaAtributos.put("descError", null);
										Ab18aRealizarProcesoBD.getInstance().actualizarPeticionEnvio(connectionOracle, mapaAtributos);
										enviarServicioEvento(peticion.getT01IdPeticionEnvio());
									}

									// Commit
									Ab18aConexionOracle.commit(connectionOracle);
								}
							} else {
								Ab18aLog.debug(Ab18aEnvioBoletines.class.getName(), nombre_metodo,
										"El cliente de eSentool no se ha instanciado correctamente: null", 1);
							}
						} else {
							Ab18aLog.debug(Ab18aEnvioBoletines.class.getName(), nombre_metodo, "Hay errores de validacion", 1);
							Map<String, Object> mapaAtributos = new HashMap<String, Object>();
							mapaAtributos.put("descError", Ab18aPropertiesBatchManager.getProperty(Ab18aConstantes.MENSAJE_RECHAZADA_VALIDACION_ENVIO));
							mapaAtributos.put("numIntentos", 0);
							mapaAtributos.put("idPeticion", peticion.getT01IdPeticionEnvio());
							mapaAtributos.put("idEstado", RECHAZADA_VALIDACION_ENVIO);
							Ab18aRealizarProcesoBD.getInstance().actualizarPeticionEnvio(connectionOracle, mapaAtributos);
							enviarServicioEvento(peticion.getT01IdPeticionEnvio());

							// Commit
							Ab18aConexionOracle.commit(connectionOracle);
						}
					} catch (SOAPException e) {
						Ab18aLog.debug(Ab18aEnvioBoletines.class.getName(), nombre_metodo, "Error al crear la llamada de SOAP " + e, 1);
					} catch (Exception e) {
						Ab18aLog.debug(Ab18aEnvioBoletines.class.getName(), nombre_metodo,
								"Ha ocurrido un error inesperado en el envío de la petición " + e, 1);
					}
				}
			} else {
				Ab18aLog.debug(Ab18aEnvioBoletines.class.getName(), nombre_metodo, "No se han recuperado peticiones", 1);
			}

		} catch (Exception e) {
			Ab18aConexionOracle.rollback(connectionOracle);
			Ab18aLog.error(e.getClass().getName(), nombre_metodo, e.getMessage(), 1);
		} finally {
			Ab18aConexionOracle.desconectar(connectionOracle);
		}
	}

	/**
	 * Rea liza las validaciones lógicas de un anuncio contra las plantillas
	 * XSLT del DOUE
	 * 
	 * @param connectionOracle
	 *            Conexión
	 * @param lstPlantillas
	 *            Listado de plantillas
	 * @param peticion
	 *            Petición en curso
	 * @return Verdadero si no hay errores. Falso en caso de haberlos.
	 * @throws IOException
	 *             IOException
	 * @throws Ab18aException
	 *             Ab18aException
	 * @throws TransformerException
	 */
	private static boolean realizarValidacionesLogicas(Connection connectionOracle, List<Ab18aPlantillasXSLT> lstPlantillas,
			Ab18aPeticionEnvio peticion) throws IOException, Ab18aException, TransformerException {

		if (lstPlantillas.size() > 1) {
			Ab18aLog.info(Ab18aEnvioBoletines.class.getName(), "realizarValidacionesLogicas",
					"Ojo! Hay varias plantillas de validacion para el anuncio. Este caso no es posible.", 1);
		}

		for (Ab18aPlantillasXSLT ab18aPlantillasXSLT : lstPlantillas) {
			try {
				InputStream in = IOUtils.toInputStream(peticion.getT01AnuncioXml(), Ab18aConstantes.ENCODING_UTF_8);
				String xmlValidacion = Ab18aUtils.transformarXSLT(in,
						ab18aPlantillasXSLT.getT05RutaPlantillaValid() + "/" + ab18aPlantillasXSLT.getT05CodPlantillaValid());
				Ab18aLog.debug(Ab18aEnvioBoletines.class.getName(), "realizarValidacionesLogicas", "La validacion es: " + xmlValidacion, 1);
				peticion.setT01ResultValidLogica(xmlValidacion.replaceAll("\n", "").replaceAll(">\\s*<", "><"));
				Ab18aLog.debug(Ab18aEnvioBoletines.class.getName(), "realizarValidacionesLogicas",
						"Validacion sin pretty print: " + peticion.getT01ResultValidLogica(), 1);
				Ab18aRealizarProcesoBD.getInstance().actualizarPeticionResultadoValidacionLogica(connectionOracle, peticion);

				boolean validacion = xmlValidacion.indexOf(Ab18aPropertiesBatchManager.getProperty(Ab18aConstantes.NODO_ERROR_VALIDACION_LOGICA)) > -1 ? false
						: true;
				Ab18aLog.debug(Ab18aEnvioBoletines.class.getName(), "realizarValidacionesLogicas",
						"Resultado de la validación lógica: " + validacion, 1);

				return validacion;
			} catch (IOException e) {
				Ab18aLog.error(e.getClass().getName(), "No se ha encontrado la plantilla", e.getMessage(), 1);
				throw e;
			} catch (Ab18aException e) {
				Ab18aLog.error(e.getClass().getName(), "No se ha podido actualizar la peticion", e.getMessage(), 1);
				throw e;
			}
		}

		return false;
	}

	private static String[] obtenerVersionAnuncioDOUE(final Ab18aPeticionEnvio peticion) {
		String[] versionSubversion = new String[2];

		String expresionXPATH = Ab18aPropertiesBatchManager.getProperty(Ab18aConstantes.RUTA_XPATH_DOUE_VERSION);

		try {
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			// factory.setNamespaceAware(true);
			DocumentBuilder builder = factory.newDocumentBuilder();
			Document doc = builder.parse(new ByteArrayInputStream(peticion.getT01AnuncioXml().getBytes(Ab18aConstantes.ENCODING_UTF_8)));

			XPathFactory xpathfactory = XPathFactory.newInstance();
			XPath xpath = xpathfactory.newXPath();

			XPathExpression expr = xpath.compile(expresionXPATH);
			String result = (String) expr.evaluate(doc, XPathConstants.STRING);

			String[] versionSeparada = result.split("\\.");

			StringBuilder version = new StringBuilder();
			for (int i = 0; i < versionSeparada.length - 1; i++) {
				if (versionSeparada[i].startsWith(Ab18aPropertiesBatchManager.getProperty(Ab18aConstantes.LETRA_XPATH_DOUE_VERSION))) {
					versionSeparada[i] = versionSeparada[i].replace(
							Ab18aPropertiesBatchManager.getProperty(Ab18aConstantes.LETRA_XPATH_DOUE_VERSION), "");
				}
				if (version.length() > 0) {
					version.append(".");
				}
				version.append(versionSeparada[i]);
			}
			versionSubversion[0] = version.toString();
			versionSubversion[1] = versionSeparada[versionSeparada.length - 1];

		} catch (ParserConfigurationException e) {
			Ab18aLog.error(e.getClass().getName(), "La configuracion de XPATH es incorrecta: " + peticion.getT01AnuncioXml(), e.getMessage(), 1);
		} catch (SAXException e) {
			Ab18aLog.error(e.getClass().getName(), "No se ha podido analizar el XML: " + peticion.getT01AnuncioXml(), e.getMessage(), 1);
		} catch (IOException e) {
			Ab18aLog.error(e.getClass().getName(), "No se ha podido recuperar el XML: " + peticion.getT01AnuncioXml(), e.getMessage(), 1);
		} catch (XPathExpressionException e) {
			Ab18aLog.error(e.getClass().getName(), "La expresion XPATH es incorrecta: " + expresionXPATH + ". XML: " + peticion.getT01AnuncioXml(),
					e.getMessage(), 1);
		}

		return versionSubversion;
	}

	/**
	 * Metodo que llama al web service de enviar el evento
	 * 
	 * @throws Exception
	 * @throws SOAPFaultException
	 */
	private static void enviarServicioEvento(Integer idPeticionEnvio) throws SOAPException, Exception {
		String resultado = "";
		try {
			String targetNameSpace = "http://com.ejie.ab18a.webservice";
			String method = Ab18aConstantes.SERVICIO_ENVIAR_EVENTO_NOMBRE_METODO;
			String url = Ab18aConstantes.URL_SERVICIO_INTEGRACION;
			String[] params = { "idPeticionEnvio" };
			String[] values = { String.valueOf(idPeticionEnvio) };

			resultado = Ab18aWSUtils.llamarWS(targetNameSpace, url, method, params, values);
			resultado = Ab18aConstantes.CTE_TRUE;

		} catch (SOAPException se) {
			resultado = Ab18aConstantes.CTE_FALSE;
			throw se;
		} catch (Exception ex) {
			resultado = Ab18aConstantes.CTE_FALSE;
			throw ex;
		}
	}
}
